import { tassign } from 'tassign';
import {
  FETCH_BOOKMARKS,
  SET_CURRENT_BOOKMARK_SELECTED,
  REMOVE_BOOKMARK,
  ADD_BOOKMARK,
  ADD_BOOKMARK_TAG,
  DELETE_BOOKMARK_TAG,
  ADD_FILTER_TAG,
  FILTERED_BOOKMARKS,
  CLEAR_FILTERS,
  UPDATE_SELECTED_TAG,
  UPDATE_FILTERED_LIST,
  UPDATE_BOOKMARKED_MAPPING,
} from '../actions';

function fetchBookmarks(state, action) {
  return tassign(state, {
    bookmarks: action.payload
  })
}

function setCurrentBookmarkSelected(state, action) {
  return tassign(state, {selectedBookmark: action.payload});
}

function updateCurrentBookmark(state, action) {
  return tassign(state, {selectedBookmark: action.payload});
}

function updateRemoveBookmark(state, action) {
  const newArray = state.bookmarks.concat();
  newArray.splice(state.bookmarks.indexOf(state.selectedBookmark),1);
  //newArray.splice(action.payload, 1);
  return tassign(state, {bookmarks: newArray});
}

function addBookmark(state, action) {
  const newArray = state.bookmarks.concat();
  //newArray.push(action.payload);
  newArray.splice(0,0,action.payload);
  return tassign(state, {bookmarks: newArray});
}

function addBookmarkTag(state, action) {
   //const newArray = state.selectedBookmark.labels.concat();
   //newArray.push(action.payload);
   var newBookmarkList = state.bookmarks.concat();
   var index = state.bookmarks.indexOf(state.selectedBookmark);
   if (index > -1) {
     newBookmarkList[index] = action.payload;
   }
  return tassign(state, {bookmarks: newBookmarkList});
  //return tassign(state, {tags: action.payload});
}

function deleteBookmarkTag(state, action) {
  // const newArray = state.selectedBookmark.labels.concat();
  // newArray.push(action.payload);
   var newBookmarkList = state.bookmarks.concat();
   var obj = state.bookmarks.find(bookmark => bookmark.conceptUri == action.payload.conceptUri);
   var index = state.bookmarks.indexOf(obj);
   if (index > -1) {
     newBookmarkList[index] = action.payload;
   }
  return tassign(state, {bookmarks: newBookmarkList});
}

function addFilterTag(state, action) {
  return tassign(state, {currentFilterTag: action.payload});
}

function filterBookmarks(state, action) {
  return tassign(state, {filteredBookmarks: action.payload});
}

function clearFilters(state, action) {
  //state.filteredBookmarks = [];
  return tassign(state, {filteredBookmarks: [], bookmarks: action.payload, currentFilterTag: {}});
}

function setSelectedTag(state, action) {
  return tassign(state, {currentFilterTag : action.payload});
}

function updateFilteredList(state, action) {
      const newArray = state.bookmarks.concat();
      const newFitleredList = newArray.filter(bookmark =>
        bookmark.labels != null ? (bookmark.labels.find(tag => tag.name == state.currentFilterTag.name) != undefined) : false) ;
  return tassign(state, {filteredBookmarks: newFitleredList});
}

function updateBookmarkedMapping(state, action) {
  // const newArray = state.bookmarks.concat();
  var obj = state.bookmarks.find(bookmark => bookmark.conceptUri == action.payload.conceptUri);
  if (obj != null) {
    obj.hasMapping = action.payload.mappingFlag;
  }
  return tassign(state, obj);
}

const INITIAL_STATE = {
  bookmarks: [],
  selectedBookmark: {},
  currentFilterTag: {},
  filteredBookmarks: [],
};
export default function bookMarkReducer(state=INITIAL_STATE, action) {
  switch (action.type) {
    case FETCH_BOOKMARKS:
      return fetchBookmarks(state, action);
    case SET_CURRENT_BOOKMARK_SELECTED:
      return setCurrentBookmarkSelected(state, action);
    case REMOVE_BOOKMARK:
      return updateRemoveBookmark(state, action);
    case ADD_BOOKMARK:
      return addBookmark(state, action);
    case ADD_BOOKMARK_TAG:
      return addBookmarkTag(state, action);
    case DELETE_BOOKMARK_TAG:
      return deleteBookmarkTag(state, action);
    case ADD_FILTER_TAG:
      return addFilterTag(state, action);
    case FILTERED_BOOKMARKS:
      return filterBookmarks(state, action);
    case CLEAR_FILTERS:
      return clearFilters(state, action);
    case UPDATE_SELECTED_TAG:
      return setSelectedTag(state, action);
    case UPDATE_FILTERED_LIST:
      return updateFilteredList(state, action);
    case UPDATE_BOOKMARKED_MAPPING:
      return updateBookmarkedMapping(state, action);
  }
  return state;
}